<?php
/**
 * The template part for displaying content
 *
 * @package WordPress
 * @subpackage Automatic
 * @since Automatic 1.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header"> 
		<?php if ( has_post_thumbnail( get_the_ID() ) ) : ?>
			<div class="thumbnail-post">
				<a href="<?php the_permalink();?>" title="<?php the_title(); ?>"><?php the_post_thumbnail( 'full' ); ?></a>
			</div>
		<?php endif; ?>
		<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
		<?php echo automatic_post_meta(); ?>
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php
			/* translators: %s: Name of current post */
			the_content();
			wp_link_pages( array(
				'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'automatic' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'automatic' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<div class="post-bottom">
			<a class="read-more" href="<?php the_permalink();?>" title="<?php the_title(); ?>"><?php echo esc_html__( 'read more','automatic'); ?></a>
			<div class="social-share f_right"><span class="txt-share"><?php echo esc_html__('Share','automatic'); ?></span><?php automatic_socials_share(get_the_permalink(), get_the_title()); ?></div>
		</div>
		<?php edit_post_link( esc_html__( 'Edit', 'automatic' ), '<footer class="entry-footer"><span class="edit-link">', '</span></footer><!-- .entry-footer -->' ); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
